<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddCategoryIdAndStatusToCoursesTable extends Migration
{
    public function up()
    {
        Schema::table('courses', function (Blueprint $table) {
            $table->unsignedBigInteger('Category_id')->nullable()->after('Language_id');
            $table->enum('Status', ['draft', 'active', 'inactive', 'archived'])->default('draft')->after('Price');

            $table->foreign('Category_id', 'courses_category_id_foreign')->references('Category_id')->on('course_categories')->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::table('courses', function (Blueprint $table) {
            $table->dropForeign('courses_category_id_foreign');
            $table->dropColumn('Category_id');
            $table->dropColumn('Status');
        });
    }
}
